<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package o66FsWp
 */
?><!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width"/>
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <script>
        // <![CDATA[
        window.cssMinUrl = '<?php echo get_stylesheet_directory_uri(); ?>/styles/site.min.css';
        window.cssOverUrl = '<?php echo get_stylesheet_directory_uri(); ?>/overwrite.css';
        // ]]>
    </script>
    <noscript id="css-async">
        <link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/styles/site.min.css">
    </noscript>
    <?php //wp_head(); ?>
    <?php // test wp head string
    if (!is_404()) {
        $template = get_page_template_slug($post->ID);
    }

    wp_head();

    ?>
    <link rel='shortcut icon' type='image/x-icon' href='<?php echo get_stylesheet_directory_uri(); ?>/images/scFace.png' />
</head>
<body <?php body_class(); ?> id="site-body">

<?php

require( 'loader.php' ); ?>
<div class="blok site-root" style="opacity: 0">
<header>
    <div class="container header-container hidden-xs hidden-sm">
        <div class="row">
            <div class="col-xs-12">
                <div class="blok header-logo-blok">
                    <h1 class="site-title">
                        <a href="<?php echo esc_url(home_url('/')); ?>"
                           rel="home">
                            <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/scLogoVect.svg"
                                 class="img-responsive"/>
                        </a>
                    </h1>
                </div>

            </div>
        </div>
    </div>
    <nav id="site-navigation" class="site-header__main-navigation hidden-xs hidden-sm">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <nav>
                        <?php
                        //                    $theme_location = 'menu-1';
                        // if ( ($theme_location) && ($locations = get_nav_menu_locations()) && isset($locations[$theme_location]) ) {
                        //	 $menu       = get_term( $locations[ $theme_location ], 'nav_menu' );
                        //	 $menu_items = wp_get_nav_menu_items( $menu->term_id );
                        //
                        //	 var_dump($menu_items);
                        //

                        /*
                         *
                        <div class="menu-menu-1-container"><ul id="primary" class="menu"><li id="menu-item-7" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-home menu-item-7"><a href="//192.168.1.7:3000/helijet/">Pagina di esempio.</a></li>
<li id="menu-item-92" class="menu-item menu-item-type-post_type menu-item-object-page current-menu-item page_item page-item-90 current_page_item menu-item-92"><a href="//192.168.1.7:3000/helijet/elicotteri/">Elicotteri</a></li>
<li id="menu-item-93" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-has-children menu-item-93"><a href="#">Test Parent</a>
<ul class="sub-menu">
	<li id="menu-item-94" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-94"><a href="//192.168.1.7:3000/helijet/news/">News</a></li>
</ul>
</li>
</ul></div>

                         */

                        // }
                        ?><?php

                        $theme_location = 'primary';
                        $locations = get_nav_menu_locations();
                        $is_loc_isset = isset($locations[$theme_location]);
                        $menu = get_term($locations[$theme_location], 'nav_menu');
                        $menu_items = wp_get_nav_menu_items($menu->term_id);


                                                wp_nav_menu(array(
                                                    'theme_location' => 'primary',
                                                    'menu_id' => 'primary',
                                                ));


                        ?>

                    </nav>
                    <div class="social_lang">
                        <?php if ( have_rows( 'social', 'option' ) ) : ?>
                            <?php while ( have_rows( 'social', 'option' ) ) : the_row(); ?>
                                <span class="span_social" style="display:none"><a href="<?php the_sub_field( 'url' ); ?>"><i class="fa <?php the_sub_field( 'font_awesome_class_name' ); ?>"></i></a>
                                </span>
                            <?php endwhile; ?>
                        <?php else : ?>
                            <?php // no rows found ?>
                        <?php endif; ?>
                        <span class="lang">
                            <span><i class="fa fa-globe" style="margin-right: 5px"></i><a href="<?php echo get_site_url();?>/?lang=es">ES</a> <a href="<?php echo get_site_url();?>/?lang=it">IT</a> <a href="<?php echo get_site_url();?>/?lang=en">EN</a></span>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </nav>
</header>
<?php include('menu-mobile.php');?>

<?php
//if (!is_front_page()){
////get_template_part('template-parts/common/breadcrumb');
//}else {
//  //  get_template_part( 'template-parts/content-slider' );
//}
?>

