<?php

/**
 * Created by PhpStorm.
 * User: marco
 * Date: 15/07/18
 * Time: 18.41
 *
 *          _____ _____________       _    ___              ________
 *   ____  / ___// ___/_  __/ /_  ___| |  / (_)__ _      __/ ____/ /___ ___________
 *  / __ \/ __ \/ __ \ / / / __ \/ _ \ | / / / _ \ | /| / / /   / / __ `/ ___/ ___/
 * / /_/ / /_/ / /_/ // / / / / /  __/ |/ / /  __/ |/ |/ / /___/ / /_/ (__  |__  )
 * \____/\____/\____//_/ /_/ /_/\___/|___/_/\___/|__/|__/\____/_/\__,_/____/____/
 *
 *
 *  TODO: approfondire e valutare refactoring: https://stackoverflow.com/questions/43657446/simple-template-in-php-output-buffering-performance
 *
 */
class o66TheViewClass {
	private static $is_initialized = false;
	private static $model_flat_fields = null;
	private static $model_view_array = array();

//	private static $jedi = 'Darth Vader: ';

	private static function initialize() {

		//Prevents re-init !important
		if ( self::$is_initialized ) {
			return;
		}
		self::$model_flat_fields = o66TheModel::getTheModelFieldsArray();

		//TODO better singleton?
		self::$is_initialized = true;

	}

	public static function html5_element( $element_name, $element_content, $element_id = null, $element_classes = null, $element_attributes = null ) {
		self::initialize();
		$element_id_render         = '';
		$element_classes_render    = '';
		$element_attributes_render = '';

		if ( $element_id !== null ) {
			$element_id_render = ' id="' . $element_id . '"';
		}
		if ( $element_classes !== null ) {
			$element_classes_render = ' class="' . $element_classes . '"';
		}
        if ( $element_attributes !== null ) {
            $element_attributes_render = ' '.$element_attributes.' ';
        }
		//if ($element_classes !== null){$element_classes_render = ' class="'.$element_classes.'"';}

		$element_html5 = "<${element_name}${element_id_render}${element_classes_render}${element_attributes_render}>${element_content}</${element_name}>";

		return $element_html5;
	}

	/**
	 * @param string $component_name
	 * @param OneModel $model
	 *
	 * @return mixed
	 */
	public static function getComponent( $component_name, $model ) {
		self::initialize();
		$fields_id          = $model->getID();
		$fields_in_view     = self::$model_flat_fields[ $fields_id ];


		$template_part_load = "components/${component_name}/${component_name}";
		if ( ! function_exists( $component_name ) ) {
			get_template_part( $template_part_load );
		}

		return call_user_func( $component_name, $fields_in_view );
	}

	/**
	 * @param OneModel $model
	 * @param string $position
	 */
	public static function assignModelToView( $model, $position = 'main' ) {
		self::initialize();
		self::$model_view_array[ $position ] = $model;
	}

	public static function getComponentAndConnectToModelVielPosition( $component_name, $position ) {
		self::initialize();

		return self::getComponent( $component_name, self::$model_view_array[ $position ] );
	}


	public static function getModelViewField( $field = o66_model_fields_keys::content, $position = 'main' ) {
		self::initialize();
		$model_fields_array = o66TheModel::getTheModelFieldsArray();
		$model_view         = self::$model_view_array[ $position ];
		$model_id           = $model_view->getId();
		$field_content      = $model_fields_array[ $model_id ][ $field ];

		return $field_content;
	}

	public static function getView( $view_name ) {
		self::initialize();
		$view_path = "views/${view_name}/${view_name}-view";
		get_template_part( $view_path );
		$this_view_function = call_user_func( $view_name );

		return $this_view_function;
	}

	public static function hasViewModelPositionChildren( $position = 'main' ) {
		self::initialize();
		$model_children = o66TheModel::getTheChildrenArray();;
		$model_view = self::$model_view_array[ $position ];
		$model_id   = $model_view->getId();
		if ( isset( $model_children[ $model_id ] ) ) {
			return true;
		} else {
			return false;
		}

	}

	public static function getChildComponent( $component_name, $child_model_id ) {
		self::initialize();
		$fields_id          = $child_model_id;
		$fields_in_view     = self::$model_flat_fields[ $fields_id ];
		$template_part_load = "components/${component_name}/${component_name}";
		if ( ! function_exists( $component_name ) ) {
			get_template_part( $template_part_load );
		}

		return call_user_func( $component_name, $fields_in_view );
	}


	public static function getViewModelPositionChildren ($position = 'main') {
		self::initialize();
		$model_children = o66TheModel::getTheChildrenArray();;
		$model_view = self::$model_view_array[ $position ];
		$model_id   = $model_view->getId();
		if ( isset( $model_children[ $model_id ] ) ) {
			return $model_children[ $model_id ];
		} else {
			return false;
		}

	}

	/**
	 * @return array
	 */
	public static function getModelViewArray() {
		self::initialize();

		return self::$model_view_array;
	}
}