<?php
/**
 * Created by PhpStorm.
 * User: marco
 * Date: 30/04/18
 * Time: 15.47
 */

class o66m {

	private static $greeting = 'All Hail ';
	private static $initialized = false;
	private static $postObject = null;
	private static $pagePostThumbnailID = 0;
	private static $postID = 0;
	private static $uploadPath = null;
	private static $mediaPath = null;
	private static $mediaSrc = null;
	private static $imConvertCommand = null;
	private static $imComposeCommand = null;


	/**
	 * o66p constructor.
	 */

	private static function initialize() {

		if ( self::$initialized ) {
			return;
		}

		global $post;

		self::$greeting .= ' the Dark Lord of the Twin Moons';


		self::$postObject          = $post;
		self::$postID              = $post->ID;
		self::$pagePostThumbnailID = get_post_thumbnail_id( self::$postID );

		self::$uploadPath = wp_upload_dir();
		self::$mediaPath  = self::$uploadPath ['basedir'] . '/o66media/';
		if ( ! file_exists( self::$mediaPath ) ) {
			mkdir( self::$mediaPath );
		}
		self::$mediaSrc         = content_url() . '/uploads/o66media/';
		self::$imConvertCommand = '/usr/bin/convert ';
		self::$imComposeCommand = '/usr/bin/composite ';

		self::$initialized = true;


	}

	public static function greet() {
		self::initialize();
		echo self::$greeting;
		//var_dump( self::$postObject );
	}

	private static function checkAndExec( $imagePath, $execCommand, $forceGeneration = false ) {
		$imageFileResultExists = file_exists( $imagePath );
		$willGenerate          = false;
		if ( $imageFileResultExists == false || $forceGeneration == true ) {
			$willGenerate = true;
			exec( $execCommand );
		}

		return $willGenerate;
	}

	public static function getMediaInfo() {

		$returnArray = array(
			'uploadPath' => self::$uploadPath['basedir'],
			'mediaPath'  => self::$mediaPath,
			'mediaSrc'   => self::$mediaSrc
		);

		return $returnArray;

	}

	public static function getImageData( $postAttachmentID = null, $wpSize = 'full' ) {
		self::initialize();
		if ( empty( $postAttachmentID ) ) {
			$postAttachmentID = self::$pagePostThumbnailID;
		}


		$imageId = $postAttachmentID;
		//var_dump( $imageId );

		//$imageFilePathOld = get_attached_file($imageId);

		//urlCompleto
		$imageFilePath = wp_get_attachment_image_src( $imageId, $wpSize );

		//server path è l'input che vuole imagemagick
		$path = $_SERVER['DOCUMENT_ROOT'] . parse_url( $imageFilePath[0], PHP_URL_PATH );


		$background_image = $path;

		$imageFileName = basename( wp_get_attachment_metadata( $imageId )['file'] );
		$imageFileExt  = pathinfo( $imageFileName, PATHINFO_EXTENSION );
		$arrayReturn   = array(
			'imageSrc'      => $imageFilePath[0],
			'imageW'        => $imageFilePath[1],
			'imageH'        => $imageFilePath[2],
			'imageFileName' => $imageFileName,
			'imageFileExt'  => $imageFileExt,
			'imagePath'     => $path
		);

		return $arrayReturn;

	}

	public static function generateFlatColorImage( $w = '100', $h = '100', $color = '000000', $extension = 'png', $forceGeneration = false, $crcName = true ) {
		self::initialize();
		$imageFileName = '';

//		$execCommand = '/usr/bin/convert' . $grayScalePostProcessExecParam . $background_image . $duoToneFilterPostProcessExecParam .
//		               $tintFilterPostProcessExecParam .
//		               $radialBlurFilterPostProcessExecParam .
//		               $blurFilterPostProcessExecParam . $noiseFilterPostProcessExecParam . $vignetteFilterPostProcessExecParam . $processedImageFullFileName;
		// convert -size 100x100 xc:wheat  canvas_wheat.gif
		$startName = 'flatColorImage-w' . $w . '-h' . $h . '-c' . $color;
		if ( $crcName == false ) {
			$imageFileName = $startName . '.' . $extension;
		}

		if ( $crcName == true ) {
			$imageFileName = crc32( $startName ) . '.' . $extension;

		}

		$imagePath = self::$mediaPath . $imageFileName;
		//	var_dump(basename($imageFileName['file']));

		$execCommand = self::$imConvertCommand . '-size ' . $w . 'x' . $h . ' xc:"#' . $color . '"  ' . $imagePath;

		$imageUrl  = self::$mediaSrc . $imageFileName;
		$generated = o66m::checkAndExec( $imagePath, $execCommand, $forceGeneration );

		//var_dump($processedImageFullFileName);

		$returnArray = array(
			'imageSrc'    => $imageUrl,
			'execCommand' => $execCommand,
			'imagePath'   => $imagePath,
			'generated'   => $generated
		);
//
//		exec($execCommand);
//
//		if ($processedImageExists == false || $forceGeneration == true) {
//			$willGenerate = true;
//			exec($execCommand);
//		}

		return $returnArray;


	}


	/**
	 * @param string $w
	 * @param string $h
	 * @param string $colorTop
	 * @param string $colorBottom
	 * @param null $distortRotate
	 * @param string $extension
	 * @param bool $forceGeneration
	 * @param bool $crcName
	 *
	 * @return array
	 */

	public static function generateLinearGradientImage(
		$w = '100', $h = '100', $colorTop = 'FFFFFF', $colorBottom = '000000', $distortRotate = null,
		$isRadial = false, $cropWxH = null,
		$extension = 'png', $forceGeneration = false, $crcName = true
	) {
		self::initialize();
		$radialPrefix = '';
		if ( $isRadial == true ) {
			$radialPrefix = 'radial-';
		}
		$willGenerate = false;

//		$execCommand = '/usr/bin/convert' . $grayScalePostProcessExecParam . $background_image . $duoToneFilterPostProcessExecParam .
//		               $tintFilterPostProcessExecParam .
//		               $radialBlurFilterPostProcessExecParam .
//		               $blurFilterPostProcessExecParam . $noiseFilterPostProcessExecParam . $vignetteFilterPostProcessExecParam . $processedImageFullFileName;
		// convert -size 100x100  gradient:green-yellow      gradient_range3.jpg
		$distortCommand = '';
		if ( ! empty( $distortRotate ) ) {
			$distortCommand = ' -distort SRT ' . $distortRotate . ' ';
		}


		$startName = 'verticalGradientImage-w' . $w . '-h' . $h . '-g' . $colorTop . '-' . $colorBottom . $radialPrefix . $distortRotate;

		//	$startName = 'flatImage-w' . $w . '-h' . $h . '-c' . $color;
		if ( $crcName == false ) {
			$imageFileName = $startName . '.' . $extension;
		}

		if ( $crcName == true ) {
			$imageFileName = crc32( $startName ) . '.' . $extension;

		}


		$imagePath = self::$mediaPath . $imageFileName;
		//	var_dump(basename($imageFileName['file']));

		$execCommand = self::$imConvertCommand . '-size ' . $w . 'x' . $h . ' ' . $radialPrefix . 'gradient:"#' . $colorTop . '"-"#' . $colorBottom . '"  ' . $distortCommand . $imagePath;
		//	$execCommand = self::$imConvertCommand . '-size 100x100  gradient:tomato-steelblue '.$imagePath;

		$imageUrl = self::$mediaSrc . $imageFileName;

		$generated = o66m::checkAndExec( $imagePath, $execCommand );

//		$processedImageExists = file_exists($imagePath);
//
//		//var_dump($processedImageFullFileName);
//
//		//	$returnArray = array( 'imageSrc' => $imageUrl, 'execCommand' => $execCommand, 'imagePath' => $imagePath );
//
//		if ($processedImageExists == false || $forceGeneration == true) {
//			$willGenerate = true;
//			exec($execCommand);
//		}
		$returnArray = array(
			'imageSrc'    => $imageUrl,
			'execCommand' => $execCommand,
			'imagePath'   => $imagePath,
			'generated'   => $generated
		);

		//exec( $execCommand );

		return $returnArray;

		//	$processedImageExists = file_exists( $processedImageFullFileName );


	}


//    public static function testComposite()
//    {
//        self::initialize();
//
//
////		convert -size 64x64 gradient:             gradient_src.png
////  convert -size 64x64 gradient: -rotate 90  gradient_dst.png
////  composite gradient_src.png -compose Multiply gradient_dst.png \
////		gradient_result.png
//
//        $imageFileSource = '/home/marcocav/public_html/o66/wp-content/uploads/o66media/duoTone-hex28AB3E-E5CB7D-cl-radial-15-blur-0x8-223-full-Ganzirri.jpg';
//        $imageFileTarget = '/home/marcocav/public_html/o66/wp-content/uploads/o66media/verticalGradientImage100-100-111111-EEEEEE.png';
//        $imageFileResult = self::$mediaPath . 'mimmo.png';
//
//        $compositeString = 'composite ' . $imageFileSource . ' -compose Multiply ' . $imageFileTarget . '  ' . $imageFileResult . ' ';
//
//        exec('/usr/bin/' . $compositeString);
//
//    }


	public static function generateVerticalGradientImage( $w = '100', $h = '100', $colorTop = '111111', $colorBottom = 'EEEEEE', $extension = 'png', $forceGeneration = false, $crcName = true ) {
		self::initialize();
		$willGenerate = false;

//		$execCommand = '/usr/bin/convert' . $grayScalePostProcessExecParam . $background_image . $duoToneFilterPostProcessExecParam .
//		               $tintFilterPostProcessExecParam .
//		               $radialBlurFilterPostProcessExecParam .
//		               $blurFilterPostProcessExecParam . $noiseFilterPostProcessExecParam . $vignetteFilterPostProcessExecParam . $processedImageFullFileName;
		// convert -size 100x100  gradient:green-yellow      gradient_range3.jpg


		$startName = 'verticalGradientImage-w' . $w . '-h' . $h . '-g' . $colorTop . '-' . $colorBottom;

		//	$startName = 'flatImage-w' . $w . '-h' . $h . '-c' . $color;
		if ( $crcName == false ) {
			$imageFileName = $startName . '.' . $extension;
		}

		if ( $crcName == true ) {
			$imageFileName = crc32( $startName ) . '.' . $extension;

		}


		$imagePath = self::$mediaPath . $imageFileName;
		//	var_dump(basename($imageFileName['file']));

		$execCommand = self::$imConvertCommand . '-size ' . $w . 'x' . $h . ' gradient:"#' . $colorTop . '"-"#' . $colorBottom . '"  ' . $imagePath;
		//	$execCommand = self::$imConvertCommand . '-size 100x100  gradient:tomato-steelblue '.$imagePath;

		$imageUrl = self::$mediaSrc . $imageFileName;

		$generated = o66m::checkAndExec( $imagePath, $execCommand );

//		$processedImageExists = file_exists($imagePath);
//
//		//var_dump($processedImageFullFileName);
//
//		//	$returnArray = array( 'imageSrc' => $imageUrl, 'execCommand' => $execCommand, 'imagePath' => $imagePath );
//
//		if ($processedImageExists == false || $forceGeneration == true) {
//			$willGenerate = true;
//			exec($execCommand);
//		}
		$returnArray = array(
			'imageSrc'    => $imageUrl,
			'execCommand' => $execCommand,
			'imagePath'   => $imagePath,
			'generated'   => $generated
		);

		//exec( $execCommand );

		return $returnArray;

		//	$processedImageExists = file_exists( $processedImageFullFileName );


	}


	public static function composeTwoImageFiles( $imageFileSource, $imageFileTarget, $composeMethod = 'Multiply', $extension = 'png', $forceGeneration = false ) {


		$willGenerate = false;


		//$compositeString = self::$imComposeCommand . $imageFileSource . ' -compose ' . $composeMethod . ' ' . $imageFileTarget . '  ' . $processedImagePath . ' ';
		$compositeStringStart = self::$imComposeCommand . $imageFileSource . ' -compose ' . $composeMethod . ' ' . $imageFileTarget . '  ';

		$imageFileName      = crc32( $compositeStringStart ) . '.' . $extension;
		$processedImagePath = self::getMediaInfo()['mediaPath'] . $imageFileName;
		$processedImageSrc  = self::getMediaInfo()['mediaSrc'] . $imageFileName;

		$compositeString = $compositeStringStart . $processedImagePath;

		$willGenerate = o66m::checkAndExec( $processedImagePath, $compositeString, $forceGeneration );


		//exec( '/usr/bin/' . $compositeString );
//		$imageFileResultExists = file_exists($imageFileResult);
//
//		if ($imageFileResultExists == false || $forceGeneration == true) {
//			$willGenerate = true;
//			exec($compositeString);
//		}
		$returnArray = array(
			'imageSrc'    => $processedImageSrc,
			'execCommand' => $compositeString,
			'imagePath'   => $processedImagePath,
			'generated'   => $willGenerate
		);

		return $returnArray;


	}

	public static function convertComposeTwoImageFiles(
		$imageFileSource, $imageFileTarget, $composeMethod = 'hardlight',
		$composeAmountArgs = null, $geometryParam = null, $extension = 'png', $forceGeneration = false, $isMask = false
	) {
		$defineComposeArgsString        = '';
		$geometryBeforeCompositeCommand = '';

		if ( ! empty( $geometryParam ) ) {
			$geometryBeforeCompositeCommand = ' -geometry ' . $geometryParam . ' ';
		}

		$isAlphaCommand = '';
		if ( $isMask == true ) {
			$isAlphaCommand = '-alpha Off';
		}
		$willGenerate = false;

		if ( ! empty( $composeAmountArgs ) ) {
			$defineComposeArgsString = ' -define compose:args=' . $composeAmountArgs . ' ';
			// -define compose:args=50
		}


		//$compositeString = self::$imComposeCommand . $imageFileSource . ' -compose ' . $composeMethod . ' ' . $imageFileTarget . '  ' . $processedImagePath . ' ';
		$compositeStringStart = self::$imConvertCommand . $imageFileSource . ' ' . $imageFileTarget . ' ' . $isAlphaCommand .
		                        ' -compose ' . $composeMethod . $defineComposeArgsString . $geometryBeforeCompositeCommand . ' -composite ' . '  ';

		$imageFileName      = crc32( $compositeStringStart ) . '.' . $extension;
		$processedImagePath = self::getMediaInfo()['mediaPath'] . $imageFileName;
		$processedImageSrc  = self::getMediaInfo()['mediaSrc'] . $imageFileName;

		$compositeString = $compositeStringStart . $processedImagePath;

		$willGenerate = o66m::checkAndExec( $processedImagePath, $compositeString, $forceGeneration );


		//exec( '/usr/bin/' . $compositeString );
//		$imageFileResultExists = file_exists($imageFileResult);
//
//		if ($imageFileResultExists == false || $forceGeneration == true) {
//			$willGenerate = true;
//			exec($compositeString);
//		}
		$returnArray = array(
			'imageSrc'    => $processedImageSrc,
			'execCommand' => $compositeString,
			'imagePath'   => $processedImagePath,
			'generated'   => $willGenerate
		);

		return $returnArray;


	}

	public static function maskOverImage( $imageFileSource, $imageFileMask, $extension = 'png', $forceGeneration = false ) {
		$returnArray = self::convertComposeTwoImageFiles( $imageFileSource, $imageFileMask, 'CopyOpacity', $extension, $forceGeneration, true );

		return $returnArray;
	}

	public static function convertGrayScale( $imageFileSource, $extension = 'png', $forceGeneration = false ) {

		//"/usr/bin/convert -colorspace Gray Ganzirri.jpg/home/marcocav/public_html/o66/wp-content/uploads/o66media/223-gs-full-Ganzirri.jpg"

		$willGenerate = false;

		$convertStringStart = self::$imConvertCommand . ' -colorspace Gray ' . $imageFileSource . ' ';

		$imageFileName = crc32( $convertStringStart ) . '.' . $extension;

		$processedImagePath = self::getMediaInfo()['mediaPath'] . $imageFileName;
		$processedImageSrc  = self::getMediaInfo()['mediaSrc'] . $imageFileName;

		$compositeString = $convertStringStart . $processedImagePath;

		$willGenerate = o66m::checkAndExec( $processedImagePath, $compositeString, $forceGeneration );


		//exec( '/usr/bin/' . $compositeString );
//		$imageFileResultExists = file_exists($imageFileResult);
//
//		if ($imageFileResultExists == false || $forceGeneration == true) {
//			$willGenerate = true;
//			exec($compositeString);
//		}
		$returnArray = array(
			'imageSrc'    => $processedImageSrc,
			'execCommand' => $compositeString,
			'imagePath'   => $processedImagePath,
			'generated'   => $willGenerate
		);

		return $returnArray;

	}


	public static function convertCrop( $imageFileSource, $w = '160', $h = '90', $x = '10', $y = '10', $repage = false, $extension = 'png', $forceGeneration = false ) {

		//"/usr/bin/convert -colorspace Gray Ganzirri.jpg/home/marcocav/public_html/o66/wp-content/uploads/o66media/223-gs-full-Ganzirri.jpg"
		$repageCommand = '';
		if ( ! empty( $repage ) ) {
			$repageCommand = '+repage';
		}
		$willGenerate = false;

		$convertStringStart = self::$imConvertCommand . $imageFileSource . ' -crop ' . $w . 'x' . $h . '+' . $x . '+' . $y . '  ' . $repageCommand . '  ';

		$imageFileName = crc32( $convertStringStart ) . '.' . $extension;

		$processedImagePath = self::getMediaInfo()['mediaPath'] . $imageFileName;
		$processedImageSrc  = self::getMediaInfo()['mediaSrc'] . $imageFileName;

		$compositeString = $convertStringStart . $processedImagePath;

		$willGenerate = o66m::checkAndExec( $processedImagePath, $compositeString, $forceGeneration );


		//exec( '/usr/bin/' . $compositeString );
//		$imageFileResultExists = file_exists($imageFileResult);
//
//		if ($imageFileResultExists == false || $forceGeneration == true) {
//			$willGenerate = true;
//			exec($compositeString);
//		}
		$returnArray = array(
			'imageSrc'    => $processedImageSrc,
			'execCommand' => $compositeString,
			'imagePath'   => $processedImagePath,
			'generated'   => $willGenerate
		);

		return $returnArray;

	}


	public static function convertTint( $imageFileSource, $colorTint = 'FF0000', $colorTintValue = '100%', $extension = 'png', $forceGeneration = false ) {

		$willGenerate = false;


		$convertStringStart = self::$imConvertCommand . $imageFileSource . ' -fill "#' . $colorTint . '" -tint ' . $colorTintValue . ' ';

		$imageFileName = crc32( $convertStringStart ) . '.' . $extension;

		$processedImagePath = self::getMediaInfo()['mediaPath'] . $imageFileName;
		$processedImageSrc  = self::getMediaInfo()['mediaSrc'] . $imageFileName;

		$compositeString = $convertStringStart . $processedImagePath;

		$willGenerate = o66m::checkAndExec( $processedImagePath, $compositeString, $forceGeneration );

		$returnArray = array(
			'imageSrc'    => $processedImageSrc,
			'execCommand' => $compositeString,
			'imagePath'   => $processedImagePath,
			'generated'   => $willGenerate
		);

		return $returnArray;

	}

	public static function convertBlur( $imageFileSource, $blurValue = '0x2', $extension = 'png', $forceGeneration = false ) {

		$willGenerate = false;


		$convertStringStart = self::$imConvertCommand . $imageFileSource . ' -blur ' . $blurValue . ' ';

		$imageFileName = crc32( $convertStringStart ) . '.' . $extension;

		$processedImagePath = self::getMediaInfo()['mediaPath'] . $imageFileName;
		$processedImageSrc  = self::getMediaInfo()['mediaSrc'] . $imageFileName;

		$compositeString = $convertStringStart . $processedImagePath;

		$willGenerate = o66m::checkAndExec( $processedImagePath, $compositeString, $forceGeneration );

		$returnArray = array(
			'imageSrc'    => $processedImageSrc,
			'execCommand' => $compositeString,
			'imagePath'   => $processedImagePath,
			'generated'   => $willGenerate
		);

		return $returnArray;

	}

	public static function convertRadialBlur( $imageFileSource, $radialBlurValue = '10', $extension = 'png', $forceGeneration = false ) {

		$willGenerate = false;


		$convertStringStart = self::$imConvertCommand . $imageFileSource . ' -radial-blur ' . $radialBlurValue . ' ';

		$imageFileName = crc32( $convertStringStart ) . '.' . $extension;

		$processedImagePath = self::getMediaInfo()['mediaPath'] . $imageFileName;
		$processedImageSrc  = self::getMediaInfo()['mediaSrc'] . $imageFileName;

		$compositeString = $convertStringStart . $processedImagePath;

		$willGenerate = o66m::checkAndExec( $processedImagePath, $compositeString, $forceGeneration );

		$returnArray = array(
			'imageSrc'    => $processedImageSrc,
			'execCommand' => $compositeString,
			'imagePath'   => $processedImagePath,
			'generated'   => $willGenerate
		);

		return $returnArray;

	}

	public static function convertNoise( $imageFileSource, $attenuateNoiseValue = '0.25', $extension = 'png', $forceGeneration = false ) {

		$willGenerate = false;

		$noiseFilterPostProcessExecParam = ' -attenuate 0.25 +noise gaussian ';
		$convertStringStart              = self::$imConvertCommand . $imageFileSource . ' -attenuate ' . $attenuateNoiseValue . ' +noise gaussian ';

		$imageFileName = crc32( $convertStringStart ) . '.' . $extension;

		$processedImagePath = self::getMediaInfo()['mediaPath'] . $imageFileName;
		$processedImageSrc  = self::getMediaInfo()['mediaSrc'] . $imageFileName;

		$compositeString = $convertStringStart . $processedImagePath;

		$willGenerate = o66m::checkAndExec( $processedImagePath, $compositeString, $forceGeneration );

		$returnArray = array(
			'imageSrc'    => $processedImageSrc,
			'execCommand' => $compositeString,
			'imagePath'   => $processedImagePath,
			'generated'   => $willGenerate
		);

		return $returnArray;

	}


	public static function convertDuoTone( $imageFileSource, $colorTintBlack = 'FF0000', $colorTintWhite = '0000FF', $extension = 'png', $forceGeneration = false ) {

		$willGenerate = false;


		$convertStringStart = self::$imConvertCommand . $imageFileSource . ' +level-colors "#' . $colorTintBlack . '","#' . $colorTintWhite . '" ';

		$imageFileName = crc32( $convertStringStart ) . '.' . $extension;

		$processedImagePath = self::getMediaInfo()['mediaPath'] . $imageFileName;
		$processedImageSrc  = self::getMediaInfo()['mediaSrc'] . $imageFileName;

		$compositeString = $convertStringStart . $processedImagePath;

		$willGenerate = o66m::checkAndExec( $processedImagePath, $compositeString, $forceGeneration );

		$returnArray = array(
			'imageSrc'    => $processedImageSrc,
			'execCommand' => $compositeString,
			'imagePath'   => $processedImagePath,
			'generated'   => $willGenerate
		);

		return $returnArray;

	}


	public static function generateGrayScaleImage( $postAttachmentID = null, $wpSize = 'full', $forceGeneration = false ) {
		if ( empty( $postAttachmentID ) ) {
			$postAttachmentID = self::$pagePostThumbnailID;
		}
		$willGenerate           = false;
		$imageDataArray         = self::getImageData( $postAttachmentID, $wpSize );
		$processedImageFileName = $postAttachmentID . '-gs-' . $wpSize . '-' . $imageDataArray['imageFileName'];
		$processedImageExt      = pathinfo( $imageDataArray['imageFileName'], PATHINFO_EXTENSION );
		$processedImageCrcName  = crc32( $processedImageFileName ) . $processedImageExt;
		$processedImagePath     = self::getMediaInfo()['mediaPath'] . $processedImageFileName;
		$processedImageSrc      = self::getMediaInfo()['mediaSrc'] . $processedImageFileName;

		$processedImageExists = file_exists( $processedImagePath );

		$grayScalePostProcessExecParam = ' -colorspace Gray ';
		$convertString                 = $grayScalePostProcessExecParam . $imageDataArray['imagePath'] . ' ';

		//"/usr/bin/convert -colorspace Gray Ganzirri.jpg/home/marcocav/public_html/o66/wp-content/uploads/o66media/223-gs-full-Ganzirri.jpg"

		$execString = self::$imConvertCommand . $convertString . $processedImagePath;

		if ( $processedImageExists == false || $forceGeneration == true ) {
			$willGenerate = true;
			exec( $execString );
		}
		$returnArray = array(
			'imageSrc'     => $processedImageSrc,
			'imagePath'    => $processedImagePath,
			'execCommand'  => $execString,
			'generated'    => $willGenerate,
			'crcImagePath' => $processedImageCrcName
		);

		return $returnArray;


	}


	public static function composeImageFile( $imageFileSource, $imageFileTarget, $imageFileResult, $composeMethod = 'Multiply', $forceGeneration = false ) {
		$willGenerate = false;

		$processedImagePath = self::getMediaInfo()['mediaPath'] . $imageFileResult;
		$processedImageSrc  = self::getMediaInfo()['mediaSrc'] . $imageFileResult;

		$compositeString = self::$imComposeCommand . $imageFileSource . ' -compose ' . $composeMethod . ' ' . $imageFileTarget . '  ' . $processedImagePath . ' ';

		//exec( '/usr/bin/' . $compositeString );
		$imageFileResultExists = file_exists( $imageFileResult );

		if ( $imageFileResultExists == false || $forceGeneration == true ) {
			$willGenerate = true;
			exec( $compositeString );
		}
		$returnArray = array(
			'imageSrc'    => $processedImageSrc,
			'execCommand' => $compositeString,
			'imagePath'   => $processedImagePath,
			'generated'   => $willGenerate
		);

		return $returnArray;

	}

	public static function gradientOverImage( $colorTop = 'ff0000', $colorBottom = '0000ff', $composeMethod = 'Multiply', $grayscale = true, $postAttachmentID = null, $wpSize = 'full', $forceGeneration = false ) {
		self::initialize();
		$gsFileName = '';
		if ( $grayscale == true ) {
			$gsFileName = 'gs';
		}

		if ( empty( $postAttachmentID ) ) {
			$postAttachmentID = self::$pagePostThumbnailID;
		}

		$willGenerate   = false;
		$imageDataArray = self::getImageData( $postAttachmentID, $wpSize );
		//$imageFileName = 'verticalGradientImage' . $w . '-' . $h . '-' . $colorTop . '-' . $colorBottom . '.' . $extension;
		$processedImageFileName = $postAttachmentID . '-go-' . $colorTop . $colorBottom . $composeMethod . $wpSize . $gsFileName . '-' . $imageDataArray['imageFileName'];
		$processedImageExt      = pathinfo( $imageDataArray['imageFileName'], PATHINFO_EXTENSION );
		$processedImageCrcName  = crc32( $processedImageFileName ) . $processedImageExt;
		$processedImagePath     = self::getMediaInfo()['mediaPath'] . $processedImageFileName;
		$processedImageSrc      = self::getMediaInfo()['mediaSrc'] . $processedImageFileName;

		//genera gradient
		$composeSrcPath   = $imageDataArray['imagePath'];
		$verticalGradient = self::generateVerticalGradientImage( $imageDataArray['imageW'], $imageDataArray['imageH'], $colorTop, $colorBottom );

		if ( $grayscale == true ) {

			$composeSrcPath = self::generateGrayScaleImage()['imagePath'];

		}

		//$processedImageExists = file_exists( $processedImagePath );

		$composition = self::composeImageFile( $composeSrcPath, $verticalGradient['imagePath'], $processedImageFileName, $composeMethod );
		//$composition = null;
		$returnArray = $composition;

		return $returnArray;


	}


	public static function postProcessStack( $postAttachmentID = null, $filterArgs = null, $wpSize = 'full', $forceGeneration = false ) {

		self::initialize();

		//	$canStartProcessing = false;


		//recupero id e file url e path
		if ( empty( $postAttachmentID ) ) {
			$postAttachmentID = self::$pagePostThumbnailID;
		}
		$imageId = $postAttachmentID;
		//var_dump( $imageId );

		//$imageFilePathOld = get_attached_file($imageId);

		//$imageData = self::getImageData($postAttachmentID);

		//urlCompleto
		$imageFilePath = wp_get_attachment_image_src( $imageId, $wpSize );

		//server path è l'input che vuole imagemagick
		$path = $_SERVER['DOCUMENT_ROOT'] . parse_url( $imageFilePath[0], PHP_URL_PATH );

		$background_image = $path;
		$upload_dir       = wp_upload_dir();
		$base_dir         = $upload_dir['basedir'] . '/o66media/';
		if ( ! file_exists( $base_dir ) ) {
			mkdir( $base_dir );
		}

		// nome.jpg
		$imageFileName = basename( wp_get_attachment_metadata( $imageId )['file'] );

		//	var_dump($imageFileName);
		//var_dump($imageFilePath);


		//var_dump($filterArgs);

		//valori default postprocess

		$grayScalePostProcessExecParam     = ' ';
		$grayScalePostProcessFileNameParam = '';

		$radialBlurFilterPostProcessExecParam     = '';
		$radialBlurFilterPostProcessFileNameParam = '';

		$blurFilterPostProcessExecParam     = '';
		$blurFilterPostProcessFileNameParam = '';

		$duoToneFilterPostProcessExecParam     = '';
		$duoToneFilterPostProcessFileNameParam = '';

		$tintFilterPostProcessExecParam     = '';
		$tintFilterPostProcessFileNameParam = '';

		$noiseFilterPostProcessExecParam     = '';
		$noiseFilterPostProcessFileNameParam = '';

		$vignetteFilterPostProcessExecParam     = '';
		$vignetteFilterPostProcessFileNameParam = '';

		$returnArray = null;

		foreach ( $filterArgs as $filter_key => $filter_arg ) {
			//	var_dump( $filter_key );
			//	var_dump( $filter_arg );

			if ( $filter_key == 'grayScale' ) {
				//if ($grayscale == true) {$grayscaleParam = '-colorspace Gray'; $grayscaleName = 'bw';}

				if ( ! empty( $filter_arg ) ) {

					$grayScalePostProcessExecParam     = ' -colorspace Gray ';
					$grayScalePostProcessFileNameParam = '-gs';
				}


			}

			if ( $filter_key == 'radialBlurFilter' ) {

				if ( ! empty( $filter_arg ) ) {
					$radialValue                              = $filter_arg;
					$radialBlurFilterPostProcessExecParam     = ' -radial-blur ' . $radialValue . ' ';
					$radialBlurFilterPostProcessFileNameParam = '-rb-' . str_replace( '.', '', $radialValue );

				}

			}

			if ( $filter_key == 'blurFilter' ) {

				if ( ! empty( $filter_arg ) ) {
					$blurValue = $filter_arg;

					$blurFilterPostProcessExecParam     = ' -blur ' . $blurValue . ' ';
					$blurFilterPostProcessFileNameParam = '-b' . $blurValue;

				}

			}

			if ( $filter_key == 'duoToneFilter' ) {

				if ( ! empty( $filter_arg ) ) {
					$colorBlack = $filter_arg[0];
					$colorWhite = $filter_arg[1];

					$duoToneFilterPostProcessExecParam     = ' +level-colors "#' . $colorBlack . '","#' . $colorWhite . '" ';
					$duoToneFilterPostProcessFileNameParam = '-dT-hb' . $colorBlack . '-hw' . $colorWhite;

				}

			}

			if ( $filter_key == 'tintFilter' ) {

				if ( ! empty( $filter_arg ) ) {
					$colorTint      = $filter_arg[0];
					$colorTintValue = $filter_arg[1];


					$tintFilterPostProcessExecParam = ' -fill "#' . $colorTint . '" -tint ' . $colorTintValue . ' ';
					//	$tintFilterPostProcessExecParam = '-size 100x100 xc:skyblue -composite \ ';
					//	$tintFilterPostProcessExecParamBf = ' -size 100x100 xc:skyblue -composite \ ';
					$tintFilterPostProcessFileNameParam = '-t' . $colorTint;

				}

			}

			if ( $filter_key == 'noiseFilter' ) {
				//if ($grayscale == true) {$grayscaleParam = '-colorspace Gray'; $grayscaleName = 'bw';}

				if ( ! empty( $filter_arg ) ) {

					$noiseFilterPostProcessExecParam     = ' -attenuate 0.25 +noise gaussian ';
					$noiseFilterPostProcessFileNameParam = '-n';
				}


			}

			if ( $filter_key == 'vignetteFilter' ) {
				//if ($grayscale == true) {$grayscaleParam = '-colorspace Gray'; $grayscaleName = 'bw';}

				if ( ! empty( $filter_arg ) ) {

					//$vignetteFilterPostProcessExecParam     = ' -background black -vignette 0x250+-20-20  ';
					$vignetteFilterPostProcessExecParam     = ' -background black -vignette 100x65000';
					$vignetteFilterPostProcessFileNameParam = '-v';
				}


			}


		}

		//	$processedImageFileNameOld = 'duoTone-hex'.$colorBlack.'-'.$colorWhite.'-'.$grayscaleName.'-'.$radialName.'-'.$blurName.'-'.$imageId.'-'.$wpSize.'-'.$imageFileName;
		$processedImageFileName = $imageId . $grayScalePostProcessFileNameParam .
		                          $duoToneFilterPostProcessFileNameParam .
		                          $tintFilterPostProcessFileNameParam .
		                          $radialBlurFilterPostProcessFileNameParam . $blurFilterPostProcessFileNameParam .
		                          $noiseFilterPostProcessFileNameParam . $vignetteFilterPostProcessFileNameParam . '-' . $wpSize . '-' . $imageFileName;

		$processedImageFullFileName = $base_dir . $processedImageFileName;
		//	var_dump(basename($imageFileName['file']));

		$processedImageUrl = content_url() . '/uploads/o66media/' . $processedImageFileName;

		//var_dump($processedImageFullFileName);

		$processedImageExists = file_exists( $processedImageFullFileName );

		$execCommand = '/usr/bin/convert' . $grayScalePostProcessExecParam . $background_image . $duoToneFilterPostProcessExecParam .
		               $tintFilterPostProcessExecParam .
		               $radialBlurFilterPostProcessExecParam .
		               $blurFilterPostProcessExecParam . $noiseFilterPostProcessExecParam . $vignetteFilterPostProcessExecParam . $processedImageFullFileName;

		//	var_dump($execCommand);
		$returnArray = array( $processedImageUrl, $execCommand );

		$willGenerate = false;
		if ( $processedImageExists == false || $forceGeneration == true ) {
			$willGenerate = true;
			exec( $execCommand );
		}
		array_push( $returnArray, $willGenerate );

		return $returnArray;

		//	exec( '/usr/bin/convert '.$grayscaleParam.' ' . $background_image .
		//	      ' +level-colors "#' . $colorBlack . '","#' . $colorWhite . '" '.$radialParam.'  '.$blurParam.'  -attenuate 0.25 +noise gaussian ' . $processedImageFullFileName );


	}


}