<?php
/**
 * o66FsWp functions and definitions
 *
 *  HERE WE GO!
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package o66FsWp
 */


if ( ! function_exists( 'o66fswp_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function o66fswp_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on o66FsWp, use a find and replace
		 * to change 'o66fswp' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'o66fswp', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'primary' => esc_html__( 'Primary', 'o66fswp' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			//	'comment-form',
			//	'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'o66fswp_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );
	}
endif;
add_action( 'after_setup_theme', 'o66fswp_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function o66fswp_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'o66fswp_content_width', 640 );
}

add_action( 'after_setup_theme', 'o66fswp_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function o66fswp_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'o66fswp' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'o66fswp' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}

add_action( 'widgets_init', 'o66fswp_widgets_init' );

function disable_emojis() {
	//non capisco
//	remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
//	remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
//	remove_action( 'wp_print_styles', 'print_emoji_styles' );
//	remove_action( 'admin_print_styles', 'print_emoji_styles' );
//	remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
//	remove_filter( 'comment_text_rss', 'wp_staticize_emoji' );
//	remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
//	add_filter( 'tiny_mce_plugins', 'disable_emojis_tinymce' );
//	add_filter( 'wp_resource_hints', 'disable_emojis_remove_dns_prefetch', 10, 2 );
}

add_action( 'init', 'disable_emojis' );

/**
 * Enqueue scripts and styles.
 */
function o66fswp_scripts() {
	/*
	 * TUTTO NOTATO PERCHè CARICO IL JS ASYNC NEL FOOTER, IL CSS CARICATO DAL JS con PROMISE
	 */

	// wp_enqueue_script( 'owl-carousel', get_stylesheet_directory_uri() . '/owl.carousel.js', array( 'jquery' ) );
	//	wp_enqueue_script( 'theme-scripts', get_stylesheet_directory_uri() . '/website-scripts.js', array( 'owl-carousel', 'jquery' ), '1.0', true )
	//wp_enqueue_script( 'js-site', get_stylesheet_directory_uri() . '/js/site.min.js');
	//wp_enqueue_style( 'o66fswp-style', get_stylesheet_uri() );


//	wp_enqueue_script( 'o66fswp-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20151215', true );
//
//	wp_enqueue_script( 'o66fswp-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20151215', true );
//
//	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
//		wp_enqueue_script( 'comment-reply' );
//	}
}
//add_action( 'wp_enqueue_scripts', 'o66fswp_scripts' );
add_action('stan_hook', 'stan_function');

function prent_r($val){
	echo '<pre style="background-color: #555555; color:#ffffff; padding: 15px">';
	print_r($val);
	echo '</pre>';
}

require_once( 'o66-core/o66.php' );


//add_action( 'acf/save_post', 'update_css_overwrite', 10,3 );
function update_css_overwrite( $post_ID, $post, $update ) {
//	if ($post_ID === 'options') {
//		$themePath = get_template_directory().'/';
//		$css_field = get_field('css_overwrite', $post_ID);
//		if (!empty($css_field)) {
//			$screen = get_current_screen();
//			get_the_title( $post_ID );
//
//			$css_file = fopen( $themePath . 'overwrite.css', "w" ) or die( "Unable to open file!" );
//			$txt = $css_field;
//			fwrite( $css_file, $txt );
//			//$txt = "Jane Doe\n";
//			//fwrite($myfile, $txt);
//			fclose( $css_file );
//		}
//
//		//update_field( 'css_overwrite', $themePath, 'options' );
//		//do_action('f');
	//}

}

//TODO ELEGANTISSIMO, capire meglio classe che ho fatto per il sorting, refactorare meglio
//add_action( 'acf/save_post', 'sort_events_timeline_on_update', 10,3 );
//function sort_events_timeline_on_update($post_ID, $post, $update){
//	$acf_reapeter = get_field('events', $post_ID);
//	if ( ! empty( $acf_reapeter ) ) {
//		//var_dump($acf_reapeter);
//		$sorter = new o66_FieldSorter('event_date');
//		usort($acf_reapeter, array($sorter, "cmp"));
//		//$sorted_and_reversed = array_reverse($acf_reapeter);
//		$sorted_and_reversed = $acf_reapeter;
//		//var_dump($sorted_and_reversed);
//		$selector = 'events';
//		$value = $sorted_and_reversed;
//		update_field($selector, $value, $post_ID);
//	}
//
//}

//per cose di cache di server. questo comando è necessario per evitare un warning se è attivata la cache di apache tramite cpanel PERFORMANCE
remove_action( 'shutdown', 'wp_ob_end_flush_all', 1 );

function bytes_to_kb($yoursize) {
	return (number_format(($yoursize/1024), 0, ',', 'u'));
}

add_filter( 'body_class','my_body_classes' );
function my_body_classes( $classes ) {

	$classes[] = 'preloader-class';

	return $classes;

}

$global_site_name = get_bloginfo('name');




//add_htaccess($htArray);
///**
// * Implement the Custom Header feature.
// */
//require get_template_directory() . '/inc/custom-header.php';
//
///**
// * Custom template tags for this theme.
// */
//require get_template_directory() . '/inc/template-tags.php';
//
///**
// * Functions which enhance the theme by hooking into WordPress.
// */
//require get_template_directory() . '/inc/template-functions.php';
//
///**
// * Customizer additions.
// */
//require get_template_directory() . '/inc/customizer.php';
//
///**
// * Load Jetpack compatibility file.
// */
//if ( defined( 'JETPACK__VERSION' ) ) {
//	require get_template_directory() . '/inc/jetpack.php';
//}

//add_action( 'wp', 'nino' );
//function nino() {
//	global $post;
//	var_dump($post);
//}

