<?php

/**
 * Created by PhpStorm.
 * User: marco
 * Date: 10/07/18
 * Time: 17.55
 *
 * OneModelClass
 *
 *    ____             __  ___          __     __________
 *   / __ \____  ___  /  |/  /___  ____/ /__  / / ____/ /___ ___________
 *  / / / / __ \/ _ \/ /|_/ / __ \/ __  / _ \/ / /   / / __ `/ ___/ ___/
 * / /_/ / / / /  __/ /  / / /_/ / /_/ /  __/ / /___/ / /_/ (__  |__  )
 * \____/_/ /_/\___/_/  /_/\____/\__,_/\___/_/\____/_/\__,_/____/____/
 *
 *
 */
class OneModel {

	private $ID,  $name, $content, $model_type;

	/**
	 * OneModel constructor.
	 *
	 * @param $ID int
	 * @param $name string
	 * @param $content string
	 * @param $model_type string
	 */
	public function __construct( $ID, $name, $content, $model_type ) {
		$this->ID         = $ID;
		$this->name       = $name;
		$this->content    = $content;
		$this->model_type = $model_type;

	}

	/**
	 * @return int
	 */
	public function getID(): int {
		return $this->ID;
	}

	/**
	 * @return string
	 */
	public function getName(): string {
		return $this->name;
	}

	/**
	 * @return string
	 */
	public function getContent(): string {
		return $this->content;
	}

	/**
	 * @return string
	 */
	public function getModelType(): string {
		return $this->model_type;
	}

	/**
	 * @return array
	 */
	public function getOneModelArray(): array {
		$this_sub_model_array = array(
			'ID'         => self::getID(),
			'name'       => self::getName(),
			'content'    => self::getContent(),
			'model_type' => self::getModelType()
		);
		return $this_sub_model_array;
	}
}