<?php
/**
 * Created by PhpStorm.
 * User: marco
 * Date: 06/07/18
 * Time: 17.03
 */

/**
 * @param $component_name
 * @param $position
 *
 * @return mixed
 */
function get_component($component_name, $position = 'main')
{
    return o66TheViewClass::getComponentAndConnectToModelVielPosition($component_name, $position);
}

function get_label($label_title)
{
    $label_name_minus = sanitize_title($label_title);
    $label_name = str_replace('-', '_', $label_name_minus);
    $label_field = get_field($label_name, 'options');
    if (!empty($label_field)) {
        return $label_field;
    } else {
        return $label_title;
    }
}

/**
 * Grab the url of a publicly embeddable video hosted on vimeo
 * @param  $vimeo_url string  The "embed" url of a video
 * @return string            The url of the thumbnail, or false if there's an error
 */
function grab_vimeo_thumbnail($vimeo_url){
    if( !$vimeo_url ) return false;
    $data = json_decode( file_get_contents( 'http://vimeo.com/api/oembed.json?url=' . $vimeo_url ) );
    if( !$data ) return false;
    return $data->thumbnail_url;
}

function has_view_model_position($position = 'main')
{
    return o66TheViewClass::hasViewModelPositionChildren($position);
}

//function get_child_component($component_name)

function html5_div($element_content, $element_id = null, $element_classes = null)
{
    return o66TheViewClass::html5_element('div', $element_content, $element_id, $element_classes);
}

function html5_h1($element_content, $element_id = null, $element_classes = null)
{
    return o66TheViewClass::html5_element('h1', $element_content);
}

function html5_h3($element_content, $element_id = null, $element_classes = null)
{
    return o66TheViewClass::html5_element('h3', $element_content);
}

function html5_ul($element_content, $element_id)
{
    return o66TheViewClass::html5_element('ul', $element_content, $element_id);
}

function html5_li($element_content)
{
    return o66TheViewClass::html5_element('li', $element_content);
}