<?php
/**
 * Created by PhpStorm.
 * User: marco
 * Date: 09/07/17
 * Time: 20.09
 */
class o66s
{
    private static $greeting = 'Vader: ';
    private static $initialized = false;
    private static $siteName = '';
    private static $siteSlug = o66SiteSettings::site_slug;
    private static $siteThemeFolder = '';
    private static $siteDescription = '';
    private static $siteThemePath = '';
    private static $o66systemApps = array();
    private static $o66coreApps = array();
    private static $o66systemLogs = array();


    private static function initialize()
    {
        if (self::$initialized)
            return;

        self::$greeting .= ' He will join us or die, Master!';
        self::$siteSlug = 'o66core';
        self::$siteThemeFolder = get_stylesheet_directory_uri();
        self::$siteThemePath = get_template_directory();
        self::$siteName = esc_html(get_bloginfo('name'));
        self::$siteDescription = get_bloginfo('description');
//        self::$o66systemApps = array('Router','Ajax');
//        $string = file_get_contents(self::$siteThemePath."/core/o66coreApps.json");
//        $json = json_decode($string, true);
//
//        self::$o66coreApps = $json;
//        array_push(self::$o66systemLogs,'INIT - '.date('H : i / s'));
        self::$initialized = true;
    }

    public static function greet()
    {
        self::initialize();
        echo self::$greeting;
    }
    public static function setGreet($greet)
    {
        self::initialize();
        self::$greeting = $greet;
    }

    /**
     * @param string $stringa
     */
    public static function setO66systemLogs($stringa)
    {
        self::initialize();
        array_push(self::$o66systemLogs,$stringa.' - '.date('H : i / s'));
    }

    /**
     * @return array
     */
    public static function getO66systemLogs()
    {
        self::initialize();
        return self::$o66systemLogs;
    }

    public static function renderO66systemLogs()
    {
        self::initialize();
        echo '<pre>';
        print_r(self::$o66systemLogs);
        echo '</pre>';
    }

    /**
     * @return string
     */
    public static function getSiteDescription()
    {
        self::initialize();
        return self::$siteDescription;
    }

    /**
     * @return string
     */
    public static function getSiteName()
    {
        self::initialize();
        return self::$siteName;
    }

    /**
     * @return string
     */
    public static function getSiteThemePath()
    {
        self::initialize();
        return self::$siteThemePath;
    }

	/**
	 * @return string
	 */
	public static function getSiteThemeFolder(  ) {
		self::initialize();
		return self::$siteThemeFolder;
	}

    /**
     * @return array
     */
    public static function getO66systemApps()
    {
        self::initialize();
        return self::$o66systemApps;
    }

    /**
     * @return array
     */
    public static function getO66coreApps()
    { self::initialize();
        return self::$o66coreApps;
    }

    public static function checkO66coreAppIndex($appName, $appPostType){
        $appSlug = strtolower($appName);
        $args = array(
            'posts_per_page' => 1,
            'offset' => 0,
            'category' => '',
            'category_name' => '',
            'orderby' => 'date',
            'order' => 'DESC',
            'include' => '',
            'exclude' => '',
      //      'meta_key' => 'app_slug',
       //     'meta_value' => $appSlug,
            'meta_query'	=> array(
                'relation'		=> 'AND',
                array(
                    'key'	 	=> 'app_slug',
                    'value'	  	=> $appSlug,
                    'compare' 	=> '=',
                ),
                array(
                    'key'	  	=> 'app_post_type',
                    'value'	  	=> $appPostType,
                    'compare' 	=> '=',
                ),
            ),
            'post_type' => 'app_index',
            'post_mime_type' => '',
            'post_parent' => '',
            'author' => '',
            'author_name' => '',
            'post_status' => 'publish',
          //  'name' => $appSlug,
            'suppress_filters' => true
        );
        $posts_array = get_posts($args);
        
        if (empty($posts_array)) {
            $my_post = array(

                'post_title' => $appName,
                'post_type' => 'app_index',
                'post_status' => 'publish'
            );
            $post_id = wp_insert_post($my_post);
          update_field('app_slug',$appSlug,$post_id);
          update_field('app_post_type',$appPostType,$post_id);

        }
    }

	/**
	 * @param $fineNameMin
	 * @param array $arrayValues
	 *
	 * Cerca il file nella cartella JS e passa i valori in un array, nel JS utitlizza obj_'nomefile'.chiaveValore come oggetto
	 *
	 */
	public  static  function enqueueJs($fineNameMin, $arrayValues = array()) {
		wp_enqueue_script($fineNameMin, get_template_directory_uri() . '/js/'.$fineNameMin.'.min.js');
		if (!empty($arrayValues)) {
			wp_localize_script( $fineNameMin, 'obj_' . $fineNameMin, $arrayValues );
		}

	}

	public  static  function enqueueCoreJs($fineNameMin, $arrayValues = array()) {
		wp_enqueue_script($fineNameMin, get_template_directory_uri() . '/core/js/'.$fineNameMin.'.min.js');
		if (!empty($arrayValues)) {
			wp_localize_script( $fineNameMin, 'obj_' . $fineNameMin, $arrayValues );
		}

	}

	public  static  function enqueueLibJs($fineNameMin, $arrayValues = array()) {
		wp_enqueue_script($fineNameMin, get_template_directory_uri() . '/core/lib/js/'.$fineNameMin.'.min.js');
		if (!empty($arrayValues)) {
			wp_localize_script( $fineNameMin, 'obj_' . $fineNameMin, $arrayValues );
		}

	}

}