<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package o66FsWp
 */

//PENSARE SOLUZIONE PER GLOBAL INDEX
global $index_count;

if ( $index_count % 2 == 0 ) {
	$isEven          = true;
	$containerEvOrOd = 'container-even';
} else {
	$isEven          = false;
	$containerEvOrOd = 'container-odd';
};
$col_big_pull   = '';
$col_small_push = '';
if ( $isEven === false ) {
	$col_big_pull   = ' col-md-pull-4 ';
	$col_small_push = ' col-md-push-8 ';
}


$heading_level = 1;
$image         = get_the_post_thumbnail_url( get_the_ID(), 'rect' );
$col_big       = 'col-md-8';
$col_small     = 'col-md-4';
if ( empty( $image ) ) {
	$col_big      = 'col-md-12';
	$col_small    = null;
	$col_big_pull = ' ';
}
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="blok post-index__item-container">
        <div class="row row--post-index">
			<?php if ( ! empty( $col_small ) ) : ?>
                <div class="<?php echo $col_small . $col_small_push; ?> hidden-sm hidden-xs">
                    <div class="blok img-responsive-container">
                        <img src="<?php echo $image; ?>" alt="<?php the_title(); ?>"/>
                    </div>
                </div>
			<?php endif; ?>
            <div class="<?php echo $col_big . $col_big_pull; ?> col-grey <?php echo $containerEvOrOd; ?>">
                <div class="entry-content entry-content--post-index">
                    <div class="entry-header__title-container">
						<?php o66fswp_the_extended_title( 'extended_title', 2 ) ?>
                        <div class="entry-header__entry-date"><i
                                    class="fa fa-calendar-o"></i> <?php echo get_the_date(); ?></div>
                    </div>
                    <div class="blok img-responsive-container hidden-lg hidden-md mar-bot">
                        <img src="<?php echo $image; ?>" alt="<?php the_title(); ?>"/>
                    </div>
                    <p><?php echo get_the_excerpt(); ?></p>
                    <?php if (!empty($image)) : ?>

                    <?php endif; ?>
                    <div class="entry-content--post-index__button-container">
						<?php o66fpwp_a_button( get_the_permalink(), 'leggi tutto', '<i class="fa fa-arrow-circle-o-right"></i>' ); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</article>
