<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package o66FsWp
 */
$heading_level = 1;
$image = get_the_post_thumbnail_url( get_the_ID(), 'rect' );
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <header class="entry-header entry-header--single">
		<?php o66fswp_main_image(o66_image_sizes::nocrop_container); ?>
		<?php if ( is_front_page() ) {
			$heading_level = '2';
		} ?>
        <div class="entry-header__title-container">
            <?php o66fswp_the_extended_title( 'extended_title', $heading_level ) ?>
            <div class="entry-header__entry-date"><i class="fa fa-calendar-o"></i> <?php echo get_the_date(); ?></div>
        </div>
    </header><?php // o66fswp_post_thumbnail(); ?>
    <div class="entry-content entry-content--page">
		<?php
		the_content();
		o66fswp_the_content_block();
		o66fswp_the_section_repeater_block();
		?>
    </div>
</article>
